# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nick Lemaire lemaire.nick@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gio, Gtk # pylint: disable=E0611
import logging
import os
logger = logging.getLogger('unity_bookmarks_lib')
from .helpers import get_builder, show_uri, get_help_uri


# This class is meant to be subclassed by UnityBookmarksWindow.  It provides
# common functions and some boilerplate.
class Window(Gtk.Window):
    __gtype_name__ = "Window"

    # To construct a new instance of this method, the following notable 
    # methods are called in this order:
    # __new__(cls)
    # __init__(self)
    # finish_initializing(self, builder)
    # __init__(self)
    #
    # For this reason, it's recommended you leave __init__ empty and put
    # your initialization code in finish_initializing
    
    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated BaseUnityBookmarksWindow object.
        """
        builder = get_builder('UnityBookmarksWindow')
        new_object = builder.get_object("unity_bookmarks_window")
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called while initializing this instance in __new__

        finish_initializing should be called after parsing the UI definition
        and creating a UnityBookmarksWindow object with it in order to finish
        initializing the start of the new UnityBookmarksWindow instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self, True)
        self.PreferencesDialog = None # class
        self.preferences_dialog = None # instance
        self.AboutDialog = None # class

        self.settings = Gio.Settings("net.launchpad.unity-bookmarks")
        self.settings.connect('changed', self.on_preferences_changed)
        
        # Optional Launchpad integration
        # This shouldn't crash if not found as it is simply used for bug reporting.
        # See https://wiki.ubuntu.com/UbuntuDevelopment/Internationalisation/Coding
        # for more information about Launchpad integration.
        try:
            from gi.repository import LaunchpadIntegration # pylint: disable=E0611
            LaunchpadIntegration.add_items(self.ui.helpMenu, 1, True, True)
            LaunchpadIntegration.set_sourcepackagename('unity-bookmarks')
        except ImportError:
            pass

        # Optional application indicator support
        # Run 'quickly add indicator' to get started.
        # More information:
        #  http://owaislone.org/quickly-add-indicator/
        #  https://wiki.ubuntu.com/DesktopExperienceTeam/ApplicationIndicators
        try:
            from unity_bookmarks import indicator
            # self is passed so methods of this class can be called from indicator.py
            try:
				with open(getConfigPath() + 'indicator') as f:
					pid = f.read()
					if os.path.exists("/proc/"+pid):
						pass
					else:
						os.remove(getConfigPath() + 'indicator')
						check = open(getConfigPath() + "indicator", "w")
						pid = str(os.getpid())
						check.write(pid)
						check.close()
						self.indicator = indicator.new_application_indicator(self)
			except IOError as e:
				check = open(getConfigPath() + "indicator", "w")
				pid = str(os.getpid())
				check.write(pid)
				check.close()
				self.indicator = indicator.new_application_indicator(self)
        except ImportError:
            pass
     
    def on_up_clicked(self,widget):
        print "up clicked"
    
    def on_down_clicked(self,widget):
        print "down clicked"
       
    def on_Add_clicked(self,widget):
		try:
			from unity_bookmarks.AddbookmarkdialogDialog import AddbookmarkdialogDialog
			addDialog = AddbookmarkdialogDialog()
			result = addDialog.run()
			addDialog.hide()
			try:
				from unity_bookmarks import indicator
				indicator.refresh_menu()
			except ImportError:
				pass
		except ImportError:
			pass
        #self.update_bookmarks()

    def on_mnu_contents_activate(self, widget, data=None):
        show_uri(self, "ghelp:%s" % get_help_uri())

    def on_mnu_about_activate(self, widget, data=None):
        """Display the about box for unity-bookmarks."""
        if self.AboutDialog is not None:
            about = self.AboutDialog() # pylint: disable=E1102
            response = about.run()
            about.destroy()

    def on_mnu_preferences_activate(self, widget, data=None):
        """Display the preferences window for unity-bookmarks."""

        """ From the PyGTK Reference manual
           Say for example the preferences dialog is currently open,
           and the user chooses Preferences from the menu a second time;
           use the present() method to move the already-open dialog
           where the user can see it."""
        if self.preferences_dialog is not None:
            logger.debug('show existing preferences_dialog')
            self.preferences_dialog.present()
        elif self.PreferencesDialog is not None:
            logger.debug('create new preferences_dialog')
            self.preferences_dialog = self.PreferencesDialog() # pylint: disable=E1102
            self.preferences_dialog.connect('destroy', self.on_preferences_dialog_destroyed)
            self.preferences_dialog.show()
        # destroy command moved into dialog to allow for a help button


    
    def getConfigPath(self):
		path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
		if not os.path.exists(path):
			os.makedirs(path)	
		return path
    
    def on_mnu_close(self, widget, data=None):
        """Signal handler for closing the UnityBookmarksWindow."""
        print "on menu close button"
        try:
			os.remove(self.getConfigPath() + 'indicator-checkfile')
		except os.error:
			pass
        Gtk.main_quit()



    def on_preferences_changed(self, settings, key, data=None):
        logger.debug('preference changed: %s = %s' % (key, str(settings.get_value(key))))

    def on_preferences_dialog_destroyed(self, widget, data=None):
        '''only affects gui
        
        logically there is no difference between the user closing,
        minimising or ignoring the preferences dialog'''
        logger.debug('on_preferences_dialog_destroyed')
        # to determine whether to create or present preferences_dialog
        self.preferences_dialog = None
	
	result = True
    def setShown(self, para):
        global result
        result = para

    def getShown(self):
		global result
        return result

def getConfigPath():
	path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
	if not os.path.exists(path):
		os.makedirs(path)	
	return path
