# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nick Lemaire lemaire.nick@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gettext
from gettext import gettext as _
gettext.textdomain('unity-bookmarks')

from gi.repository import Gtk, Unity, Dbusmenu # pylint: disable=E0611
from gi.repository import GdkPixbuf
import logging
logger = logging.getLogger('unity_bookmarks')
from unity_bookmarks import read_xml
from unity_bookmarks import write_xml
from unity_bookmarks_lib import Window
from unity_bookmarks.AboutUnityBookmarksDialog import AboutUnityBookmarksDialog
from unity_bookmarks.AddbookmarkdialogDialog import AddbookmarkdialogDialog
from unity_bookmarks.PreferencesUnityBookmarksDialog import PreferencesUnityBookmarksDialog
from unity_bookmarks.CustomCellRenderer import CellRendererPixbuff
import webbrowser
import urllib


# See unity_bookmarks_lib.Window.py for more details about how this class works
class UnityBookmarksWindow(Window):
    __gtype_name__ = "UnityBookmarksWindow"
    selected_name = ""
    selected_url = ""


    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the main window"""

        super(UnityBookmarksWindow, self).finish_initializing(builder)

        self.AboutDialog = AboutUnityBookmarksDialog
        self.PreferencesDialog = PreferencesUnityBookmarksDialog
        self.toolbar = self.builder.get_object('toolbar')

        context = self.toolbar.get_style_context()
        context.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
		
		self.openimage = self.builder.get_object('image3')
		
		self.share = self.builder.get_object('share')
		self.sharemenu = Gtk.Menu()
		self.sharemenu.show()
		
		self.googleshare = Gtk.ImageMenuItem.new_with_label("Google+")
		self.googleshare.set_image(Gtk.Image.new_from_file("/opt/extras.ubuntu.com/unity-bookmarks/share/unity-bookmarks/media/google.png"))
		self.googleshare.show()
		self.googleshare.connect("activate",self.on_googleplus_clicked)
		self.googleshare.set_always_show_image(True)
		self.sharemenu.append(self.googleshare)
		
		self.fbshare = Gtk.ImageMenuItem.new_with_label("Facebook")
		self.fbshare.set_image(Gtk.Image.new_from_file("/opt/extras.ubuntu.com/unity-bookmarks/share/unity-bookmarks/media/facebook.png"))
		self.fbshare.show()
		self.fbshare.connect("activate",self.on_facebook_clicked)
		self.fbshare.set_always_show_image(True)
		self.sharemenu.append(self.fbshare)
		
		self.twitshare = Gtk.ImageMenuItem.new_with_label("Twitter")
		self.twitshare.set_image(Gtk.Image.new_from_file("/opt/extras.ubuntu.com/unity-bookmarks/share/unity-bookmarks/media/twitter.png"))
		self.twitshare.show()
		self.twitshare.connect("activate",self.on_twitter_clicked)
		self.twitshare.set_always_show_image(True)
		self.sharemenu.append(self.twitshare)
		
		self.share.set_menu(self.sharemenu)
		

        bookmarks = read_xml.read_Xml()	

        ### TABLE ####
        self.viewport = self.builder.get_object('viewport')

        # CREATE LISTSTORE & TREEVIEW
        self.liststore = Gtk.ListStore(str, str, str,str,str)
		self.treeview = Gtk.TreeView(self.liststore)

        column_count = Gtk.TreeViewColumn("#")
        column_count.set_expand(False)
        column_text = Gtk.TreeViewColumn("Bookmark")
        column_text.set_expand(True)
        column_pixbuf = Gtk.TreeViewColumn("Delete")
        column_pixbuf.set_expand(False)
        column_pixbuf2 = Gtk.TreeViewColumn("Edit")
        column_pixbuf2.set_expand(False)
        
        # ADD COLUMNS
        self.treeview.append_column(column_count)
        self.treeview.append_column(column_text)
        self.treeview.append_column(column_pixbuf2)        
        self.treeview.append_column(column_pixbuf)

        cellrenderer_count = Gtk.CellRendererText()
        column_count.pack_start(cellrenderer_count,False)
        column_count.add_attribute(cellrenderer_count, "text", 4)

        cellrenderer_text = Gtk.CellRendererText()
        column_text.pack_start(cellrenderer_text, False)
        column_text.add_attribute(cellrenderer_text, "text", 0)
     
        cellrenderer_pixbuf = CellRendererPixbuff()
        column_pixbuf.pack_start(cellrenderer_pixbuf, False)
        column_pixbuf.add_attribute(cellrenderer_pixbuf, "stock-id", 2)

        cellrenderer_pixbuf2 = CellRendererPixbuff()
        column_pixbuf2.pack_start(cellrenderer_pixbuf2, False)
        column_pixbuf2.add_attribute(cellrenderer_pixbuf2, "stock-id", 1)

        # CONNECT SIGNALS FOR CALLBACK CLICK ON CELL
        cellrenderer_pixbuf.connect('clicked', self.on_delete_clicked)
        cellrenderer_pixbuf2.connect('clicked', self.on_edit_clicked)

        # CONNECT SIGNALS FOR CALLBACK SELECTION
        self.tree_selection = self.treeview.get_selection()
        self.tree_selection.connect('changed',self.on_selection_changed)
        self.tree_selection.set_mode(1) #single selection mode
        
        # CONNECT LISTSTORE WITH TREEVIEW
        self.treeview.set_model(self.liststore)
        
        # FILL DATA IN TABLE
        for row in bookmarks:
            self.liststore.append([row['name'], Gtk.STOCK_EDIT ,Gtk.STOCK_DELETE, row['url'],row['count']])
        
        # SHOW & ADD treeview to viewport
        self.treeview.show()   
        self.viewport.add(self.treeview)

        # DISABLE BUTTON
        self.builder.get_object("open_bookmark").set_sensitive(False)
        self.builder.get_object("share").set_sensitive(False)
        self.builder.get_object("reset_count").set_sensitive(False)

    def on_destroy(self, widget=None, data=None):
        """Called when the UnityBookmarksWindow is closed."""
        print "on destroy"
        # Clean up code for saving application state should be added here.
        self.setShown(False)

    def on_mnu_close_activate(self, widget=None, data=None):
        """Signal handler for closing the UnityBookmarksWindow."""
        print "on menu close activate"
        self.destroy()

    # CALLBACK when a bookmarks is opened to be viewed    
    def on_open_bookmark_clicked(self, widget):
        print "open bookmark in browser clicked"
        (model, iter) = self.tree_selection.get_selected()
        print  model.get_value(iter,3)          
		webbrowser.open_new_tab(model.get_value(iter,3))
        self.on_mnu_close_activate()
		write_xml.add_count_to_bookmark(model.get_value(iter,0))
        read_xml.sortBookmarks()
        try:
        	try:
				from unity_bookmarks import indicator
				indicator.refresh_menu()
			except ImportError:
				pass
		except ImportError:
			pass  				
        indicator.refresh_menu()


    def on_reset_count_clicked(self, widget):
        print "on_reset_count clicked"
		(model, iter) = self.tree_selection.get_selected()
        write_xml.reset_count(model.get_value(iter,0))        
        self.liststore.append([model.get_value(iter,0) , Gtk.STOCK_EDIT ,Gtk.STOCK_DELETE,model.get_value(iter,0),"1"])
        self.liststore.remove(iter)

    # CALLBACK when selection is changed on the table
    def on_selection_changed(self, treeselection):
        (model, iter) = treeselection.get_selected()
        if iter is not None:
            print "Iter is not None, pointing to " + model.get_value(iter,0)
            global selected_name 
            global selected_url   
            selected_name = model.get_value(iter,0)
            selected_url = model.get_value(iter,3)
            self.builder.get_object("open_bookmark").set_sensitive(True)
            self.builder.get_object("share").set_sensitive(True)
            self.builder.get_object("reset_count").set_sensitive(True)    
            self.openimage.set_from_file("/opt/extras.ubuntu.com/unity-bookmarks/share/unity-bookmarks/media/globe1.png")
        else:
            print "Iter is None"
            self.builder.get_object("open_bookmark").set_sensitive(False)
            self.builder.get_object("share").set_sensitive(False)
            self.openimage.set_from_file("/opt/extras.ubuntu.com/unity-bookmarks/share/unity-bookmarks/media/globe.png")
        print "selection changed"	

    # CALLBACK for sharing on twitter
    def on_twitter_clicked(self, widget):
        print "TWITTER SHARING"
		(model, iter) = self.tree_selection.get_selected()
        twitter_encoding = { 'source' : 'sharethiscom', 'text' : model.get_value(iter,0), 'url' : model.get_value(iter,3)}
        twitter_encoding = "http://twitter.com/intent/tweet?"+urllib.urlencode(twitter_encoding)
        webbrowser.open_new_tab(twitter_encoding)
        
    # CALLBACK for sharing on facebook
    def on_facebook_clicked(self, widget):
        print "FACEBOOK SHARING"
        (model, iter) = self.tree_selection.get_selected()
        facebook_encoding = { 'u' : model.get_value(iter,3), 't' : model.get_value(iter,0)}
        facebook_encoding = "https://www.facebook.com/sharer.php?"+urllib.urlencode(facebook_encoding)
        webbrowser.open_new_tab(facebook_encoding)    
    
    # CALLBACK for sharing on googleplus
    def on_googleplus_clicked(self, widget):
        print "PLUS 1 ON GOOGLE-PLUS"
        (model, iter) = self.tree_selection.get_selected()  
        googleplus_encoding = { 'url' : model.get_value(iter,3)}
        googleplus_encoding = "https://plus.google.com/share?"+urllib.urlencode(googleplus_encoding)
        webbrowser.open_new_tab(googleplus_encoding)    

    # CALLBACK for delete button
    def on_delete_clicked(self, cellRenderer, index):
        count = 0
        for row in self.liststore:
            if count == int(index):
                print "removing" + row[0]
                write_xml.remove_bookmark(row[0])
                self.liststore.remove(row.iter)
            count = count + 1     
        try:
        	try:
				from unity_bookmarks import indicator
				indicator.refresh_menu()
			except ImportError:
				pass
		except ImportError:
			pass  				
        indicator.refresh_menu()
        #print liststore[treeiter][index]

    # CALLBACK for edit button
    def on_edit_clicked(self, cellRenderer, index):     
        count = 0
		try:
		    from unity_bookmarks.AlterbookmarkDialog import AlterbookmarkDialog
			alterDialog = AlterbookmarkDialog()
            for row in self.liststore:
                if count == int(index):
                     alterDialog.set_old_values(row[0],row[3])
                count = count + 1			
            result = alterDialog.run()
            print result
			alterDialog.hide()
            if result == -5:
                count = 0
                for row in self.liststore:
                    if count == int(index):
                        print "removing" + row[0]
                        self.liststore.remove(row.iter)
                    count = count + 1  
                print "selection tree selection"
                self.liststore.insert(int(index),[alterDialog.getName() , Gtk.STOCK_EDIT ,Gtk.STOCK_DELETE,alterDialog.getUrl(),"1"])

                try:
				    from unity_bookmarks import indicator
				    indicator.refresh_menu()
			    except ImportError:
				    print "Error: ImportError"
	    except ImportError:
	        print "Error: ImportError"

    # CALLBACK for new bookmark button
    def on_Add_clicked(self,widget):
		try:
			from unity_bookmarks.AddbookmarkdialogDialog import AddbookmarkdialogDialog
			addDialog = AddbookmarkdialogDialog()
			result = addDialog.run()
            print result
			addDialog.hide()
            if result == -5:
                try:
                    self.liststore.append([addDialog.getName() , Gtk.STOCK_EDIT ,Gtk.STOCK_DELETE,addDialog.getUrl(),"1"])
				    from unity_bookmarks import indicator
				    indicator.refresh_menu()
			    except ImportError:
	                print "Error: ImportError"
	    except ImportError:
	        print "Error: ImportError"

    # CALLBACK for showing the preferences dialog
    def on_Preferences_clicked(self,widget):
        self.on_mnu_preferences_activate(widget, None)

	
