# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nick Lemaire lemaire.nick@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences in
# data/glib-2.0/schemas/net.launchpad.unity-bookmarks.gschema.xml
# See http://developer.gnome.org/gio/stable/GSettings.html for more info.

from gi.repository import Gio # pylint: disable=E0611

import gettext
from gettext import gettext as _
gettext.textdomain('unity-bookmarks')
import ConfigParser
import os
import shutil

import logging
logger = logging.getLogger('unity_bookmarks')

from unity_bookmarks_lib.PreferencesDialog import PreferencesDialog

class PreferencesUnityBookmarksDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesUnityBookmarksDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesUnityBookmarksDialog, self).finish_initializing(builder)
		self.config = ConfigParser.ConfigParser()
		try:
			cFile=open(getConfigPath() + "unity-bookmarks.conf")
			cFile.close()
		except IOError:
			self.write_configFile(False, True)
		self.config.read(getConfigPath() + "unity-bookmarks.conf")
        # Bind each preference widget to gsettings
        #settings = Gio.Settings("net.launchpad.unity-bookmarks")
        #widget = self.builder.get_object('example_entry')
        self.autostart = self.builder.get_object('autostart')
        self.autostart.connect("toggled",self.on_autostart_toggled)
        self.main_toggle = self.builder.get_object('main_toggle')
        self.main_toggle.connect("toggled",self.on_main_toggle_toggled)
        if self.config.get("general", "autostart") == "True":
			self.autostart.set_active(True)
		else:
			self.autostart.set_active(False)
		if self.config.get("general", "showhomeonstart") == "True":
			self.main_toggle.set_active(True)
		else:
			self.main_toggle.set_active(False)
        
	def on_autostart_toggled(self, widget):
		value = str(self.autostart.get_active())
		self.config.set("general", "autostart", value)
		confFile = open(getConfigPath() + "unity-bookmarks.conf", "w")
		self.config.write(confFile)
		if self.autostart.get_active():
			try:
				shutil.copyfile("/usr/share/applications/extras-unity-bookmarks.desktop", getAutostartPath() + "extras-unity-bookmarks.desktop")
			except:
				pass 
		else:
			try:
				os.remove(getAutostartPath() + 'extras-unity-bookmarks.desktop')
			except OSError:
				pass
		
	def on_main_toggle_toggled(self, widget):
		value = str(self.main_toggle.get_active())
		self.config.set("general", "showhomeonstart", value)
		confFile = open(getConfigPath() + "unity-bookmarks.conf", "w")
		self.config.write(confFile)
        

	def write_configFile(self, auto, main):
		cFile = open(getConfigPath() + "unity-bookmarks.conf", "w")
		self.config.add_section("general")
		self.config.set("general","autostart",auto)
		self.config.set("general","showhomeonstart",main)
		self.config.write(cFile)

def getConfigPath():
	path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
	if not os.path.exists(path):
		os.makedirs(path)	
	return path
	
def getAutostartPath():
	path = os.getenv("HOME") + "/.config/autostart/"
	if not os.path.exists(path):
		os.makedirs(path)	
	return path
