# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nick Lemaire lemaire.nick@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from unity_bookmarks_lib.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('unity-bookmarks')
from unity_bookmarks import write_xml
from unity_bookmarks import read_xml
import re

class AlterbookmarkDialog(Gtk.Dialog):
    __gtype_name__ = "AlterbookmarkDialog"
    oldname = ""
    name = ""
    url = ""
    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated AlterbookmarkDialog object.
        """
        builder = get_builder('AlterbookmarkDialog')
        new_object = builder.get_object('alterbookmark_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a AlterbookmarkDialog object with it in order to
        finish initializing the start of the new AlterbookmarkDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

    def on_btn_ok_clicked(self, widget, data=None):
        global name 
        global url 
        global oldname       
        name = self.builder.get_object("entry_name_alter").get_text()
        url = self.builder.get_object("entry_url_alter").get_text()
        if name == "":
             name = "Unknown"
        else:
            write_xml.alterBookmark(oldname,name, url)
            try:
				from unity_bookmarks import notifications
                if name == oldname:
                    notifications.notification("Unity Bookmarks", "The url of "+name + " was altered!")
                else:
                    notifications.notification("Unity Bookmarks", "The name of "+oldname + " was altered into "+name+"!")
			except ImportError:
				pass
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """
    def getName(self):
        global name
        return name
    

    def getUrl(self):
        global url
        return url

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass

    def set_old_values(self,name,url):
        global oldname
        oldname = name
        self.builder.get_object("entry_name_alter").set_text(name)
        self.builder.get_object("entry_url_alter").set_text(url)

    def on_entry_name_alter_changed(self, widget, data=None):
        global oldname
        print oldname
        errorLabel = self.builder.get_object("error_alter_bookmark") 
        okButton = self.builder.get_object("btn_ok")  
        if(str(widget.get_text()) is not ""):        
            # look up if bookmark exists
            found = False
            # check if current is equal to older value
            if str(widget.get_text()).upper() == str(oldname).upper():
                print "- Oldname is equal to input"
            else:
                listNames = read_xml.getListName()
                for name in listNames:          
                    if str(name).upper() == str(widget.get_text()).upper():
                        print "-  name found in list" + name + " " + widget.get_text()
                        found = True
                    else:
                        print "No identical name found | list : "+ name + "| widget : "+widget.get_text() 
            if found:
                errorLabel.set_text("Error: bookmark name already exists")    
                okButton.set_sensitive(False)
                
            else:
                errorLabel.set_text("")
                okButton.set_sensitive(True)
            print "End"
        else:
             errorLabel.set_text("Error: fill in a bookmark name")
             okButton.set_sensitive(False) 

    def on_entry_url_alter_changed(self, widget, data=None):
        okButton = self.builder.get_object("btn_ok")  
        output = str(self.check_url(widget.get_text())) 
        if output == "None":
            self.builder.get_object("error_alter_bookmark").set_text("Error: URL is not valid")
            okButton.set_sensitive(False)
        else:
            self.builder.get_object("error_alter_bookmark").set_text("")
            if self.builder.get_object("entry_name_alter").get_text() != "":
                    okButton.set_sensitive(True)

    def check_url(self,url):
        print url
        regex = re.compile(
            r'^(?:http|ftp)s?://' # http:// or https://
            r'(?:(?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+(?:[A-Z]{2,6}\.?|[A-Z0-9-]{2,}\.?)|' #domain...
            r'localhost|' #localhost...
            r'\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})' # ...or ip
            r'(?::\d+)?' # optional port
            r'(?:/?|[/?]\S+)$', re.IGNORECASE) 
        result = regex.match(str(url))
        return result

if __name__ == "__main__":
    dialog = AlterbookmarkDialog()
    dialog.show()
    Gtk.main()
